<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request; 
use App\Http\Controllers\Controller;
use App\Http\Requests\PersonalRequest;
use App\Http\Requests\UserRequest;
use App\Models\Egressos;
use App\Models\User;
use Illuminate\Support\Facades\Auth; 
//use Validator;
use GuzzleHttp\Client;
use Tymon\JWTAuth\Exceptions\JWTException;
use Tymon\JWTAuth\Exceptions\TokenExpiredException;
use Tymon\JWTAuth\Facades\JWTAuth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class AuthController extends Controller 
{

    /** 
     * login api 
     * 
     * @return \Illuminate\Http\Response 
     */ 
    public function auth(Request $request) 
    {   
        try {

            $validator = Validator::make($request->all(), [ 
                'email' => 'required|max:255|email',
                'password' => 'required',
            ]);
            
            if ($validator->fails()) { 
                return response()->json($validator->errors(), 401);            
            }

            //$credentials = ['email' => $request->email,  'password' => $request->password];
            $credentials = $request->only(['email', 'password']);

            try {
                //setTTL -> 60 minutos * 24 horas * número de dias
                \JWTAuth::factory()->setTTL(60*24*365);
                $token = \JWTAuth::attempt($credentials);
                if (!$token) {
                    return response()->json(['error' => 'Invalid credentials'], 401);
                }
            } catch (JWTException $e) {
                return response()->json(['error' => 'Could not authenticate'], 500);
            }

            $user = \JWTAuth::user();
            
            $token = $this->respondWithToken($token);
            $access = $token->original;


            return response()->json(compact('user', 'access'));
           

        } catch (\Exception $e) {
            return response()->json($e->getMessage(), 500);
        }
    } 

    public function me(Request $request) 
    {   
        
        try {

            if (! $user = JWTAuth::parseToken()->authenticate()) {
                    return response()->json(['user_not_found'], 404);
            }

        } catch (TokenExpiredException $e) {

                return response()->json(['token_expired'], $e->getStatusCode());

        } catch (TokenExpiredException $e) {

                return response()->json(['token_invalid'], $e->getStatusCode());

        } catch (JWTException $e) {

                return response()->json(['token_absent'], $e->getStatusCode());
        }
        
        //$egresso = Egressos::egressoselect($user->id);
        $egresso = $user->egresso;
        if($egresso)
            $egresso->convertLocalization();
        $role = count($user->getRoleNames()) > 0 ? $user->getRoleNames()[0] : null;
        $token = $this->respondWithToken(str_replace('Bearer ', '', $request->headers->get('Authorization')));
        $access = $token->original;

        unset($user->egresso);
        unset($user->roles);

        return response()->json(compact('egresso', 'user', 'role', 'access'));
    } 

    /** 
     * logout api 
     * 
     * @return \Illuminate\Http\Response 
     */ 
    public function logout()
    { 
        try {
            JWTAuth::invalidate(true);
            Auth::logout(true);
        } catch (\Exception $e) {
            return response()->json($e->getMessage(), 500);
        }
    }

    public function refreshToken($client_id, $token) { 
        $http = new Client;
        $response = $http->request('POST', 'http://mylemp-nginx/oauth/token', [
            'form_params' => [
                'grant_type' => 'refresh_token',
                'refresh_token' => 'the-refresh-token',
                'client_id' => $client_id,
                'client_secret' => $token,
                'scope' => '',
            ],
        ]);

        $result = json_decode((string) $response->getBody(), true);
        return response()->json($result, 200);
    }

    public function unauthorized(){
        return response()->json(['message'=>'Not authorized'],401);
    }

    /**
     * Refresh a token.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function refresh()
    {
        return $this->respondWithToken(auth()->factory()->setTTL(60*24*365)->refresh());
    }

    public function user_update(PersonalRequest $request, Auth $user )
    {
       try{
            $user = User::find(Auth::user()->id);
            $user->update($request->all());

       }catch(\Exception $ex){
           return response()->json($ex->getMessage(),404);
       } 
       
       return response()->json($user,200);
    }

} 