<?php

namespace App\Http\Controllers;

use App\Http\Resources\EgressoResource;
use App\Models\Egressos;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class EgressoMapController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        try{

            $data = [];

            $egressos =  new EgressoResource(Egressos::select('full_name',
                                                                'email',
                                                                'job_state',
                                                                'job_country',
                                                                DB::raw('ST_X(localization) as latitude, ST_Y(localization) as longitude'),
                                                                'allows_display_data_publicly')
                                                                ->where('status',1)
                                                                ->get());

            foreach($egressos as $egresso){
                if($egresso->latitude != 0 && $egresso->longitude != 0){
                    if($egresso->allows_display_data_publicly == 0 ){
                        $egresso->full_name = '';
                        $egresso->email = '';
                    }
                    array_push($data, [
                        'full_name' => $egresso->full_name,
                        'email' => $egresso->email,
                        'job_state' => $egresso->job_state,
                        'job_country' => $egresso->job_country,
                        'allows_display_data_publicly' => $egresso->allows_display_data_publicly,
                        'latitude' => $egresso->latitude,
                        'longitude' => $egresso->longitude,
                    ]);

                }

            }


            return response()->json($data,200);

        }catch(\Exception $e){

            return response()->json($e->getMessage(),404);
        }

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
