<?php
namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request; 
use App\Http\Controllers\Controller;
use App\Mail\ResetPassword;
use App\Models\User; 
use Illuminate\Support\Facades\Hash;
use Keygen;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Password;

class PasswordController extends Controller 
{
  /**
   * Reset password
   * @param Request $request
   * @return Response 
   */
  public function reset(Request $request) 
  {   
      try {
          $user = Password::getUser(["email" => $request->email]);
          $can = Password::tokenExists($user, $request->token);

          if(!$can)
            return response()->json("Invalid email or token", 401);

          $password = Keygen::alphanum(8)->generate('strtolower');
          $user->password = $password;
          $user->save();
          Mail::to($user)->send(new ResetPassword($password));
          Password::deleteToken($user);

          return response()->json(["message" => 'Password created and email sent'], 200);
      } catch (\Exception $e) {
          return response()->json($e->getMessage(), 500);
      }
  }
  
  /**
   * Generate the token in order to generate a new password                                  
   * @param User $user
   * @return Response 
   */
  public function forgot(User $user) 
  {   
      try {
          $token = Password::createToken($user);
          return response()->json(["token" => $token], 200);
      } catch (\Exception $e) {
          return response()->json($e->getMessage(), 500);
      }
  }
} 