<?php

namespace App\Http\Requests;

use App\Http\Requests\Request;
use App\Models\Egressos;
use App\Models\User;
use App\Rules\EmployedRule;
use App\Rules\FullNameRule;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;

class EgressoRequest extends Request
{
    protected $id;
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
     //   $this->id = Egressos::Where('user_id',Auth::user()->id)->select('id')->first();

        if (in_array($this->method(), ['POST'])) {
            return [
                'full_name' => ['required','max:255', new FullNameRule()],
                'email' => ['required', 'email', 'unique:users,email,NULL,id,deleted_at,NULL'],
                'masters_degree_year' => ['nullable','required_without:doctorate_degree_year', 'digits:4', 'integer', 'min:1900', 'max:'.(date('Y')+1)],
                'doctorate_degree_year' => ['nullable','required_without:masters_degree_year', 'digits:4', 'integer', 'min:1900', 'max:'.(date('Y')+1)],
                'job_area' => ['required_if:is_employed,yes','required_if:is_retired,1','in:PÚBLICA,PRIVADA','nullable'],
                'job_company' => ['required_if:is_employed,yes','required_if:is_retired,1'],
                'job_city' => ['required_if:job_country,Brasil'],
                'job_state' => ['required_if:job_country,Brasil'],
                'is_retired' => ['required','boolean'],
                'job_country' => ['required_if:is_employed,yes','required_if:is_retired,1'],
                'lat' => ['required_if:is_employed,yes','required_if:is_retired,1'],
                'lng' => ['required_if:is_employed,yes','required_if:is_retired,1']
            ];
        } else if(in_array($this->method(), ['PUT', 'PATCH'])){
            return [
                'full_name' => ['required','max:255', new FullNameRule()],
                'email' => ['required', 'email',/* Rule::unique('egressos')->ignore($this->users)->whereNull('deleted_at')*/],
                'masters_degree_year' => ['nullable','required_without:doctorate_degree_year', 'digits:4', 'integer', 'min:1900', 'max:'.(date('Y')+1)],
                'doctorate_degree_year' => ['nullable','required_without:masters_degree_year', 'digits:4', 'integer', 'min:1900', 'max:'.(date('Y')+1)],
                'job_area' => ['in:PÚBLICA,PRIVADA','nullable'],
                'job_country' => ['required_if:is_employed,yes','required_if:is_retired,1'],
                'job_company' => ['required_if:job_area,not nullable','required_if:is_retired,1'],
                'lat' => ['required_if:job_area,not nullable','required_if:is_retired,1'],
                'lng' => ['required_if:job_area,not nullable','required_if:is_retired,1'],
                'job_city' => ['required_if:job_country,Brasil'],
                'job_state' => ['required_if:job_country,Brasil'],
            ];
        }
    }
    public function messages()
    {
        if (in_array($this->method(), ['PUT', 'PATCH'])) {
            return  [
                'job_country.required_if' => 'É obrigatório informar o País onde trabalha',
                'job_city.required_if' => 'É obrigatório informar cidade e estado quando o país for Brasil',
                'job_state.required_if' => 'É obrigatório informar cidade e estado quando o país for Brasil',
                'job_company.required_if' => 'O campo Empresa ou Instituição é obrigatório',
                'job_area.required_if' => 'O campo Área é obrigatório, caso esteja trabalhando ou seja aposentado',
            ];
        }

        if (in_array($this->method(), ['POST'])) {
            return  [
                'job_city.required_if' => 'É obrigatório informar cidade e estado quando o país for Brasil',
                'job_state.required_if' => 'É obrigatório informar cidade e estado quando o país for Brasil',
                'job_country.required_if' => 'É obrigatório informar o País onde trabalha',
                'job_company.required_if' => 'O campo Empresa ou Instituição é obrigatório',
                'job_area.required_if' => 'O campo Área é obrigatório, caso esteja trabalhando ou seja aposentado',
            ];
        }

    }

}

