<?php

namespace App\Http\Requests;

use Illuminate\Http\JsonResponse;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Validation\ValidationException;
use Illuminate\Http\Exceptions\HttpResponseException;

class Request extends FormRequest
{
 /**
  * Handle a failed validation attempt.
  *
  * @param  \Illuminate\Contracts\Validation\Validator $validator
  * @return void
  *
  * @throws \Illuminate\Validation\ValidationException
  */
 protected function failedValidation(Validator $validator)
 {
     $errors = (new ValidationException($validator))->errors();
     throw new HttpResponseException(
         response()->json(['errors' => $errors], JsonResponse::HTTP_UNPROCESSABLE_ENTITY)
     );
 }
}
