<?php

namespace App\Http\Requests;

use App\Http\Requests\Request;
use App\Models\Egressos;
use App\Models\User;
use App\Rules\EmployedRule;
use App\Rules\FullNameRule;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;

class UserRequest extends Request
{
    protected $id;
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
   //     $this->id = Auth::user()->id;
        if (in_array($this->method(), ['POST'])){
            return [
                'email' => ['required', 'email', "unique:users,email,NULL,id,deleted_at,NULL"],
                'name' => ['required'],
                'password' => ['nullable','min:6'],
                'c_password' => ['required_with:password','same:password']
            ];
        }else if (in_array($this->method(), ['PUT','PATCH'])){
            if($this->user)
                $ruleEmail = ['required', 'email', Rule::unique('users')->ignore($this->user)->whereNull('deleted_at')];
            else
                $ruleEmail = ['required', 'email', Rule::unique('users')->ignore($this->id)->whereNull('deleted_at')];

            return [
                'email' => ['required', 'email', Rule::unique('users')->ignore($this->user)->whereNull('deleted_at')],
                'name' => ['required'],
                'password' => ['min:6'],
                'c_password' => ['required_with:password','same:password']
            ];
        }  
             
    }

    public function messages()
    {
        if (in_array($this->method(), ['PUT', 'PATCH'])) {
            return  [
                'email.unique' => "Esse endereço de e-mail já está sendo utilizado",
                'email.required' => "É obrigatório preencher o campo 'email'!",
                'name.required' => "É obrigatório preencher o campo 'nome'! ",
                'c_password.same' => "O valor do campo 'confirmação de senha' não pode ser diferente do campo senha!"
            ];
        }

        if (in_array($this->method(), ['POST'])) {
            return  [
                'email.unique' => "Esse endereço de e-mail já está sendo utilizado",
                'email.required' => "É obrigatório preencher o campo 'email'!",
                'name.required' => "O campo nome é obrigatório! ",
                'c_password.required_with' => "É obrigatório realizar a confirmação de senha!",
                'c_password.same' => "O valor do campo 'confirmação de senha' não pode ser diferente do campo senha!"
            ];
        }

    }  
}
