<?php

namespace App\Imports;

use App\Http\Requests\Request;
use App\Libs\Maps;
use App\Mail\WelcomePassword;
use App\Models\Egressos;
use App\Models\User;
use App\Rules\FullNameRule;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Password;
use Keygen\Keygen;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use Maatwebsite\Excel\Concerns\SkipsFailures;
use Maatwebsite\Excel\Concerns\SkipsOnFailure;
use Maatwebsite\Excel\Concerns\SkipsOnError;
use Maatwebsite\Excel\Concerns\SkipsErrors;
use Maatwebsite\Excel\Concerns\SkipsEmptyRows;
use Maatwebsite\Excel\Validators\Failure;
use Spatie\Permission\Models\Permission;
use Spatie\Geocoder\Geocoder;

class EgressoImport implements ToModel, WithHeadingRow, WithValidation,SkipsOnError, SkipsOnFailure
{
    use Importable, SkipsErrors;

    public function model(array $line)
    {
  
        // Gerando dados de latitude e longitude
        $address = $line['cidade_onde_trabalha'].','.$line['estado_onde_trabalha'];
        $country = (string)$line['pais_onde_trabalha'];

        $full_name = trim($line['nome_completo']);
        $email = trim($line['email']);

        $user = User::create([
            'name' => $full_name,
            'email' => $email,
            
        ])->assignRole('egresso');
        $user_id = $user->id;
        foreach($user as $egresso){

            if(strtolower($line['aposentado']) === 'sim'){
                $aponsentado = 1;
            }else{
                $aponsentado = 0;
            }
            if(strtolower($line['permitir_exibicao_publica_dos_dados']) === 'sim'){
                $allows_public = 1;
            }else{
                $allows_public = 0;
            }

            return Egressos::create([
                'full_name' => $full_name,
                'email' => $email,
                'user_id' => $user_id,
                'masters_degree_year'=> $line['ano_mestrado'],
                'doctorate_degree_year' => $line['ano_doutorado'],
                'job_area' => strtoupper($line['area_de_atuacao']),
                'job_company' => $line['instituicao_onde_trabalha'],
                'job_city' => $line['cidade_onde_trabalha'],
                'job_state' => $line['estado_onde_trabalha'],
                'job_country' => $line['pais_onde_trabalha'],
                'localization' => $this->geocoding($address, $country),
                'allows_display_data_publicly' => $allows_public,
                'status' => $line['status'],
                'is_retired' => $aponsentado,
            ]);
        }
  
    }

    public function rules(): array
    {
        return [
            '*.nome_completo' => ['required','max:255', new FullNameRule()],
            '*.email' => ['required', 'email', 'unique:users,email,NULL,id,deleted_at,NULL'],
            '*.ano_mestrado' => ['nullable', 'digits:4','integer', 'min:1900','required_without:*.ano_doutorado', 'max:'.(date('Y')+1)],
            '*.ano_doutorado' => ['nullable', 'digits:4','required_without:*.ano_mestrado','integer', 'min:1900', 'max:'.(date('Y')+1)],
            '*.area_de_atuacao' => ['required_if:if:esta_empregado,sim',Rule::in(['PÚBLICA','PRIVADA', 'Pública', 'Privada']),'nullable'],
            '*.instituicao_onde_trabalha' => ['required_if:esta_empregado,sim','required_if:aposentado,sim'],
            '*.cidade_onde_trabalha' => ['required_if:pais_onde_trabalha,Brasil'],
            '*.estado_onde_trabalha' => ['required_if:pais_onde_trabalha,Brasil'],
            '*.esta_empregado' => ['required'],
            '*.aposentado' => ['required'],
            '*.pais_onde_trabalha' => ['required_if:esta_empregado,sim','required_if:aposentado,sim'],
        ];
    }
    public function onFailure(Failure ...$failures)
    {
        echo json_encode(['alerta' => $failures]).PHP_EOL;
    }


    protected function Password(User $user)
    {
        try {
            $password = Keygen::alphanum(8)->generate('strtolower');
            $user->password = $password;
            $user->save();
        //    $mail = Mail::to($user)->send(new WelcomePassword($password));
        //    Password::deleteToken($user);

            return $password;
        } catch (\Exception $e) {
            return false;
        }
    }

    protected function geocoding($address, $country)
    {
        if($address == ","){
            $coord = $country;
        }else{
            $coord = $address;
        }
        
        $client = new \GuzzleHttp\Client();

        $geocoder = new Geocoder($client);
        $geocoder->timeout  = 10;

        $geocoder->setApiKey(config('geocoder.key'));

      //  $geocoder->setCountry(config('geocoder.country', 'BR'));
        $coordenadas = $geocoder->getCoordinatesForAddress($coord);

        $data = [
            'lat' => $coordenadas['lat'],
            'lng' => $coordenadas['lng'],
        ];
        
        if($coordenadas['lat'] !== 0 && $coordenadas['lng'] !== 0){
            $position = "ST_GeomFromText('POINT($data[lat] $data[lng])')";
            $position = DB::raw($position);
        }else{
            $position = null;
        }
        
        return $position;

    }
    
}
