<?php

namespace App\Jobs;

use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Mail;
use App\Mail\WelcomePassword;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Password;
use Keygen\Keygen;

class SendWelcomeEmail implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private $user;


    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(User $user)
    {
        $this->user = $user;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        // Send email welcome user
        Mail::to($this->user->email)
                ->send(new WelcomePassword($this->Password($this->user)));   
    }

    protected function Password(User $user)
    {
        try {
            $password = Keygen::alphanum(8)->generate('strtolower');
            $user->password = $password;
            $user->save();

            return $password;
        } catch (\Exception $e) {
            return false;
        }
    }

}
