<?php

namespace App\Models;

use App\Http\Resources\EgressoResource;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\WithValidation;

class Egressos extends Model
{

    use SoftDeletes;
    protected $table = 'egressos';

    protected $fillable = [
        'full_name',
        'email',
        'password',
        'user_id',
        'masters_degree_year',
        'doctorate_degree_year',
        'job_area',
        'job_company',
        'job_city',
        'job_state',
        'allows_display_data_publicly',
        'status',
        'is_retired',
        'job_country',
        'localization',
    ];

    protected $hidden = ['deleted_at'];
    protected $geometry = ['localization'];

    protected $geometryAsText = true;

    public function setFullNameAttribute($value)
    {
        $this->attributes['full_name'] = ucwords($value);
    }

    public function newQuery($excludeDeleted = true)
    {
        if (!empty($this->geometry) && $this->geometryAsText === true)
        {
            $raw = '';
            foreach ($this->geometry as $column)
            {
                $raw .= 'ST_AsText(`' . $this->table . '`.`' . $column . '`) as `' . $column . '`, ';
            }
            $raw = substr($raw, 0, -2);

            return parent::newQuery($excludeDeleted)->addSelect('*', DB::raw($raw));
        }

        return parent::newQuery($excludeDeleted);
    }

    public function convertLocalization(){
        if($this->localization){
            $clean = str_replace(['POINT','(',')'], '', $this->localization);
            $points = explode(' ', $clean);
            $this->latitude = floatval($points[0]);
            $this->longitude = floatval($points[1]);
        }else{
            $this->latitude = 0;
            $this->longitude = 0;
        }
        
        unset($this->localization);
    }

    public static function showegresso($id)
    {
        $egressos =  new EgressoResource(Egressos::select('*',
                                                        DB::raw('ST_X(localization) as latitude, ST_Y(localization) as longitude'),
                                                        'allows_display_data_publicly')
                                                        ->where('id',$id)
                                                        ->get());

            foreach($egressos as $egresso){

                $data = [
                    'id' => $egresso->id,
                    'user_id' => $egresso->user_id,
                    'full_name' => $egresso->full_name,
                    'email' => $egresso->email,
                    'job_city' => $egresso->job_city,
                    'job_state' => $egresso->job_state,
                    'job_country' => $egresso->job_country,
                    'job_area' => $egresso->job_area,
                    'job_company' => $egresso->job_company,
                    'is_retired' => $egresso->is_retired,
                    'masters_degree_year' => $egresso->masters_degree_year,
                    'doctorate_degree_year' => $egresso->doctorate_degree_year,
                    'status' => $egresso->status,
                    'allows_display_data_publicly' => $egresso->allows_display_data_publicly,
                    'latitude' => $egresso->latitude,
                    'longitude' => $egresso->longitude,
                    'created_at' => $egresso->created_at,
                    'updated_at' => $egresso->updated_at,
                    'deleted_at' => $egresso->deleted_at,
                ];
            }

            return $data;
    }
    static function egressoselect($user_id)
    {
        $data = [];
        $egressos = Self::select('*',
                        DB::raw('ST_X(localization) as latitude, ST_Y(localization) as longitude'),
                        'allows_display_data_publicly')
                        ->orderBy('user_id')
                        ->where('user_id',$user_id)
                        ->get();

            foreach($egressos as $i=>$egresso){

                $data[$i] = [
                    'id' => $egresso->id,
                    'full_name' => $egresso->full_name,
                    'email' => $egresso->email,
                    'user_id' => $egresso->user_id,
                    'job_city' => $egresso->job_city,
                    'job_state' => $egresso->job_state,
                    'job_country' => $egresso->job_country,
                    'job_area' => $egresso->job_area,
                    'job_company' => $egresso->job_company,
                    'is_retired' => $egresso->is_retired,
                    'masters_degree_year' => $egresso->masters_degree_year,
                    'doctorate_degree_year' => $egresso->doctorate_degree_year,
                    'allows_display_data_publicly' => $egresso->allows_display_data_publicly,
                    'latitude' => $egresso->latitude,
                    'longitude' => $egresso->longitude,
                ];

            }
                
        return $data;
    }

    public function setJobAreaAttribute($value)
    {
        $this->attributes['job_area'] =  mb_strtoupper($value);
    }


    public $timestamps = true;

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public static function SearchEgressos($perPage = 10,$page = 1, $orderBy = 'id', $orderDir = 'DESC', $term="")
    {
     
        $egressos = Self::Where('full_name','LIKE', "%$term%")
                    ->orWhere('email','LIKE',"%$term%")
                    ->orWhere('job_country','LIKE',"%$term%")
                    ->orWhere('job_city','LIKE',"%$term%")
                    ->orWhere('job_state','LIKE',"%$term%")
                    ->orWhere('job_company','LIKE',"%$term%")
                    ->when($orderBy === 'local', function($q) use($orderDir){
                        $q->orderByRaw("CONCAT(job_city,'-',job_state,',',job_country) $orderDir");
                    })
                    ->when($orderBy !== 'local', function($q) use($orderBy, $orderDir){
                        $q->orderBy($orderBy, $orderDir);
                    })
                    ->paginate($perPage, ['*'],'page',$page);
         
        return [
            'current_page' => $egressos->currentPage(),
            'data' => $egressos->items(),
            'total' => $egressos->total(),
            'count' => $egressos->count(),
            'per_page' => $egressos->perPage(),
            'total_pages' => $egressos->lastPage()
            ];
    }


}
