<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\Hash;
use Laravel\Sanctum\HasApiTokens;
use Tymon\JWTAuth\Contracts\JWTSubject;
use Spatie\Permission\Traits\HasRoles;

use App\Models\Egressos;

class User extends Authenticatable implements JWTSubject
{
    use HasApiTokens, HasFactory, Notifiable, SoftDeletes, HasRoles;
    
    protected $guard_name = 'api';
    /**
     * The attributes that are mass assignable.
     *
     * @var string[]
     */
    protected $fillable = [
        'name',
        'email',
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
        'deleted_at'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    protected function setPasswordAttribute($password)
    {   
        if (!empty($password))
        {
            $this->attributes['password'] = Hash::make($password);
        }
    }

    protected function getNameAttribute($name)
    {   
        return $name !== $this->attributes['email'] ? $name : null;
    }

    /**
     * Get the identifier that will be stored in the subject claim of the JWT.
     *
     * @return mixed
     */
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [];
    }

    public function egresso()
    {
        return $this->hasOne(Egressos::class, 'user_id');
    }

    public static function SearchUsers($perPage = 10,$page = 1, $orderBy = 'id', $orderDir = 'DESC', $term="")
    {
                    

        $users = Self::role('admin')
                    ->where(function($q) use ($term){
                        $q->where('name','LIKE', "%$term%")
                          ->orWhere('email','LIKE',"%$term%");
                    })
                    ->orderBy($orderBy,$orderDir)
                    ->paginate($perPage, ['*'],'page',$page);

        return [
            'current_page' => $users->currentPage(),
            'data' => $users->items(),
            'total' => $users->total(),
            'count' => $users->count(),
            'per_page' => $users->perPage(),
            'total_pages' => $users->lastPage()
            ];

    }
}
