<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;

class FullNameRule implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        $value = trim($value);
        if(preg_match("/^[A-zÀ-ÿ\-'][A-zÀ-ÿ\-']+\s([A-zÀ-ÿ\-']\s?)*[A-zÀ-ÿ\-'][A-zÀ-ÿ\-']+$/", $value)){
            return true;
        }else {
            return false;
        }
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'O campo :attribute deve conter ao menos nome e sobrenome.';
    }
}