<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEgressosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('egressos', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('user_id')->nullable()->unsigned();
            $table->string('full_name')->comment("Graduate\'s full name");
            $table->string('email')->comment("Email to register");
            $table->year('masters_degree_year')->nullable()->comment("Graduate year of Master\'s Degree at UFV");
            $table->year('doctorate_degree_year')->nullable()->comment("Graduate year of the Doctoral Degree at UFV");
            $table->string('job_area')->nullable()->comment("Area of ​​performance of the Egresso's current job.");
            $table->string('job_company')->nullable()->comment("Company name of the Egresso's current job.");
            $table->string('job_city')->nullable()->comment("City of the Egresso's current employment company.");
            $table->char('job_state', 2)->nullable()->comment("Estate of the Egresso's current employment company.");
            $table->boolean('allows_display_data_publicly')->comment("Egressor's permission to publicly display his/her data.")->default(false);
            $table->boolean('status')->default(0)->comment("Status of the aggressor's registration, approved (1) or disapproved (0).");
            $table->timestamps();
            $table->softDeletes();
            $table->foreign('user_id')->references('id')->on('users');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('egressos');
    }
}
