<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnEgressos extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('egressos', function (Blueprint $table) {
            $table->boolean('is_retired')->default(FALSE)->comment('Say if this person is retired or not')->nullable();
            $table->string('job_country')->after('job_state')->comment('Indicate whether this graduate works abroad')->nullable();
            $table->point('localization')->after('job_country')->comment('That is need to indicate the latitude and longitude point')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
