<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RolesAndPermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Reset cached roles and permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // create permissions
        Permission::create(['name' => 'create egresso', 'guard_name' => 'api']);
        Permission::create(['name' => 'edit egresso', 'guard_name' => 'api']);
        Permission::create(['name' => 'delete egresso', 'guard_name' => 'api']);
        Permission::create(['name' => 'access egresso', 'guard_name' => 'api']);
        Permission::create(['name' => 'import egresso', 'guard_name' => 'api']);
        Permission::create(['name' => 'create user', 'guard_name' => 'api']);
        Permission::create(['name' => 'edit user', 'guard_name' => 'api']);
        Permission::create(['name' => 'delete user', 'guard_name' => 'api']);
        Permission::create(['name' => 'access user', 'guard_name' => 'api']);

        $role = Role::create(['name' => 'admin', 'guard_name' => 'api']);
            $role->givePermissionTo(Permission::all());

        $role = Role::create(['name' => 'egresso', 'guard_name' => 'api'])
            ->givePermissionTo(['access egresso', 'create egresso']);

        $user = User::where(['name' => 'admin', 'email' => 'egressoentomol@gmail.com'])->first();
        $user->assignRole('admin');

    }
}
