<?php

use App\Http\Controllers\AuthController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\EgressoController;
use App\Http\Controllers\GoogleMapController;
use App\Http\Controllers\PasswordController;
use App\Http\Controllers\UserAdminController;
use App\Http\Middleware\JwtMiddleware;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::get('/', function(){
    return json_encode('Yuuuuu!! API worked!!!');
});

//Authenticate
Route::post('auth', 'AuthController@auth');

//Egressos - Registro
Route::post('register', [EgressoController::class,'register']);


// Map
Route::apiResource('map', 'EgressoMapController');

//Password
Route::post('password/forgot/{user:email}', [PasswordController::class, 'forgot']);
Route::post('password/reset', [PasswordController::class, 'reset']);



Route::group(['middleware' => JwtMiddleware::class], function(){
    
    // Seguimentação de Rota por perfil de usuário
    Route::group(['middleware' => ['role:admin|egresso']], function () {
        Route::get('me', 'AuthController@me');
        Route::put('me/access',     [AuthController::class,'user_update']);
        Route::put('me/personal',   [EgressoController::class, 'me']);
        
    });

    Route::group(['middleware' => ['role:admin']], function () {
        Route::prefix('egressos')->group( function () {
            // Egressos
            Route::post('import', [EgressoController::class,'EgressoImport']);
        });
        // Egressos
        Route::apiResource('egressos', 'EgressoController');
        // Usuarios
        Route::apiResource('user','UserAdminController');   
    });
    
});




